/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.servlet.util;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.ui.UIClient;
import com.ibm.hwmca.fw.ui.UIException;
import com.ibm.hwmca.fw.ui.UIObjects;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.TreePropertyListener;
import com.ibm.hwmca.ui.bonsai.servlet.BonsaiSettingsListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class UISession {
    private static final String SESSION_KEY = "com.ibm.hwmca.ui.bonsai.UISession";
    private final Object SELECTION_LOCK = new Object();
    private HMCSession hmcSession;
    private Set userRoles;
    private UIObjects uiObjects;
    private boolean activeSelectionTree;
    private boolean treeSelectionChanged = false;
    private List treeSelectionPath;
    private List tableSelection;
    private List taskNodes;
    private static final String TRACEMASK_T = "XBUISEST";
    private static final String TRACEMASK_F = "XBUISESF";
    private static final String TRACEMASK_D = "XBUISESD";

    public void init(HMCSession hmcSession) throws TaskletException, UIException, HException {
        Trace.trace(TRACEMASK_F, "--> UISession.init(" + hmcSession + ")");
        if (hmcSession == null) {
            throw new IllegalStateException("HMCSession has not yet been set!");
        }
        hmcSession.setSessionAttribute(SESSION_KEY, this);
        this.hmcSession = hmcSession;
        this.uiObjects = new UIObjects(hmcSession);
        UIClient client = this.uiObjects.getUIClient();
        client.addUserSettingsListener(new BonsaiSettingsListener(this));
        client.addUIClientListener(new TreePropertyListener(this));
        this.userRoles = User.getUser(hmcSession.getUserContext().getUserName()).getUserRoles();
        Trace.trace(TRACEMASK_F, "<-- UISession.init()");
    }

    public HMCSession getHMCSession() {
        return this.hmcSession;
    }

    public Locale getLocale() {
        return this.hmcSession.getUserContext().getLocale();
    }

    public UIClient getUIClient() {
        return this.uiObjects.getUIClient();
    }

    public UIObjectsReader getUIObjectsReader() {
        return this.uiObjects.getUIObjectsReader();
    }

    public Set getUserRoles() {
        return this.userRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActiveSelectionTree() {
        Object object = this.SELECTION_LOCK;
        synchronized (object) {
            return this.activeSelectionTree;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveSelectionTree(boolean activeSelectionTree) {
        Object object = this.SELECTION_LOCK;
        synchronized (object) {
            this.activeSelectionTree = activeSelectionTree;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTreeSelection() {
        Object object = this.SELECTION_LOCK;
        synchronized (object) {
            BonsaiTreeManager treeManager = BonsaiTreeManager.getBonsaiTreeManager();
            String id = null;
            Iterator i = this.treeSelectionPath.iterator();
            while (i.hasNext()) {
                id = (String)i.next();
                if (treeManager.getTreeNode(id) != null) {
                    return id;
                }
                i.remove();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTreeSelection(String treeSelection) {
        Object object = this.SELECTION_LOCK;
        synchronized (object) {
            BonsaiTreeManager treeManager = BonsaiTreeManager.getBonsaiTreeManager();
            this.treeSelectionPath = new ArrayList();
            for (BonsaiTreeNode node = treeManager.getTreeNode(treeSelection); node != null; node = node.getParent()) {
                this.treeSelectionPath.add(node.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTableSelection() {
        Object object = this.SELECTION_LOCK;
        synchronized (object) {
            return this.tableSelection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableSelection(List tableSelection) {
        Object object = this.SELECTION_LOCK;
        synchronized (object) {
            this.tableSelection = tableSelection;
        }
    }

    public List getResourceTaskTrees() {
        return this.taskNodes;
    }

    public void setResourceTaskTrees(List taskNodes) {
        this.taskNodes = taskNodes;
    }

    public static synchronized UISession getUISession(HMCSession hmcSession) {
        return (UISession)hmcSession.getSessionAttribute(SESSION_KEY);
    }
}

